/*
 * getpath.h
 * File revision 2
 * Process default paths a bit more intelligently.
 * (c) 2000 Jacob Lundberg, jacob@chaos2.org
 */

/*
 * 1999.10.24	original framework
 * 2000.03.12	complete rewrite
 *		moved defaults here
 * 2000.07.24	updated style
 *		moved includes to getpath.c
 */


#ifndef __GETPATH_H__
#define __GETPATH_H__


/* these are hardcoded defaults for getpath */
#define DEFPATH "/bin:/usr/bin:/sbin:/usr/sbin"
#define ETCFILE "/etc/getpath.conf"
#define HOMEFILE ".pathrc"
#define MAINTAINER "Jacob Lundberg <jacob@chaos2.org>"
#define SEPARATORS ";:\n\t, "


/* a simple s-link list */
typedef struct listitem {
   struct listitem *next;
   char *item;
} pathlist;


/* these functions do return */
int badpath(char *dirname);
void output(pathlist *head);
pathlist *list_scan(pathlist *top, char *data);
void list_insert(pathlist **top, char *data);
void list_append(pathlist **top, char *data);
void list_delete(pathlist **top, char *data);
void list_clear(pathlist **top);
int checkuser(char *data, int isuser);
int parse(pathlist **top, char *filename);
int scanlist(pathlist *head);


/* these functions do not return */
void defaults(void);
void help(void);


#endif /* ndef __GETPATH_H__ */
